// CPPToolPlugIn.h
//
// This file declares a class that implements IPlugIn. The
// implementation creates a simple tool window inside
// the user interface of the TLA.
/////////////////////////////////////////////////////////////

#pragma once

#include "ToolForm.h"

namespace CPPSamplePlugIn
{
    // CPPToolPlugIn class
    //
    // CPPToolPlugIn implements the IPlugIn interface that allows the TLA
    // application to use it as an in-process TPI.NET client.
    // This simple Tool plug-in allows the user to enable or disable all
    // LA modules in the system by pushing one of two buttons.
    
    // The use of the PlugInIdentity Attribute causes the TLA to create
    // a tool bar button and a Tools menu item to represent the installed
    // plug-in in the user interface. Pressing the toolbar button will
    // activate a single instance of the plug-in and its UI. The arguments
    // to PlugInInstantiation cause a single instance of the plug-in
    // class to instantiated whenever the TLA system is defaulted.
	[Tektronix::LogicAnalyzer::PlugIn::PlugInIdentity("CPP Sample Tool")]
	[Tektronix::LogicAnalyzer::PlugIn::PlugInInstantiation(true, true)]
	public __gc class CPPToolPlugIn : public Tektronix::LogicAnalyzer::PlugIn::IPlugIn
	{
    private:
        // Data Members.
        bool m_isValid;
        bool m_isGarbage;
        ToolForm* m_form;
	    
		// Method to handle the event raised when the plug-in UI
		//  is closed by the user.
		void OnFormClosed (System::Object* sender, System::EventArgs* e);

	public:
	
	    // Every plug-in must have a default constructor.
	    CPPToolPlugIn();

	// IPlugIn Members
	    
	    // Every plug-in has an Initialize() method that is is called by
	    // the TLA application immediately after the plug-in is instantiated.
	    bool Initialize(Tektronix::LogicAnalyzer::TpiNet::ITlaPlugInSupport* support,
	                    bool userInit);

	    // Property that provides a reference to the primary user inteface
	    // window of the plug-in. The TLA will use this property to find and 
	    // activate the main window of a plug-in when its tool bar button 
	    // is pressed.
	    __property System::Windows::Forms::Form* get_PrimaryForm() { return m_form; }

    // IDisposable Member
	    
	    // Method that invalidates the plug-in and disposes of its window.
	    void Dispose();
	    
	// IValidity Members

		// Property that flags whether the plug-in is 
		// valid to be part of the system.
	    __property bool get_IsValid() { return m_isValid; }

		// Property that indicates whether the plug-in is permanently
		// invalid. This value should always be set to true when a
		// plug-in is disposed.
	    __property bool get_IsGarbage() { return m_isGarbage; }

	    // The plug-in raises this event when either of the above two 
	    // properties change state.
	    virtual __event System::EventHandler* ValidityChanged;
	};
}
